/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ReportPurgeTool {
    private String m_dirPath = null;
    private String m_fileNameBegin = null;
    private String m_fileExtn = null;
    private String[] m_listOfFileNames = null;
    private File[] m_listOfFilePaths = null;
    private Comparator<File> compareTimeStampAscending = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return new Long(file1.lastModified()).compareTo(new Long(file2.lastModified()));
        }
    };
    private Comparator<File> compareTimeStampDecending = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return new Long(file2.lastModified()).compareTo(new Long(file1.lastModified()));
        }
    };

    public ReportPurgeTool(String dirPath, String fileNameBeginStr, String fileExtn) {
        this.m_dirPath = dirPath;
        this.m_fileNameBegin = fileNameBeginStr;
        this.m_fileExtn = fileExtn;
        this.initialize();
    }

    private void initialize() {
        File dir = new File(this.m_dirPath);
        if (dir.exists() && dir.isDirectory()) {
            MatchPattern filter = new MatchPattern(this.m_fileNameBegin, this.m_fileExtn);
            this.m_listOfFileNames = dir.list(filter);
            this.m_listOfFilePaths = dir.listFiles(filter);
        }
    }

    public void purgeOlderFiles(int count) throws ClusterException {
        this.purge(count, true);
    }

    public void purgeNewerFiles(int count) throws ClusterException {
        this.purge(count, false);
    }

    private void purge(int numOfFilesToKeep, boolean older) throws ClusterException {
        if (this.m_listOfFilePaths == null || this.m_listOfFilePaths.length == 0 || this.m_listOfFilePaths.length <= numOfFilesToKeep) {
            return;
        }
        if (older) {
            Arrays.sort(this.m_listOfFilePaths, this.compareTimeStampDecending);
        } else {
            Arrays.sort(this.m_listOfFilePaths, this.compareTimeStampAscending);
        }
        int count = this.m_listOfFilePaths.length;
        for (File file : this.m_listOfFilePaths) {
            if (count > numOfFilesToKeep) {
                String path = file.getAbsolutePath();
                new ClusterCmd().removeFileFromNode("localnode", path);
            }
            --count;
        }
        this.initialize();
    }

    public void deleteAllFiles() throws ClusterException {
        if (this.m_listOfFileNames != null && this.m_listOfFileNames.length > 0) {
            this.purgeOlderFiles(0);
        }
    }

    private void copyFile(String file1, String file2) throws IOException {
        File f1 = new File(file1);
        File f2 = new File(file2);
        FileInputStream f1In = new FileInputStream(f1);
        FileOutputStream f2Out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        int length = 0;
        while ((length = f1In.read(buf)) > 0) {
            f2Out.write(buf, 0, length);
        }
        f1In.close();
        f2Out.close();
    }

    private class MatchPattern
    implements FilenameFilter {
        String m_fileNameBeginStr = null;
        String m_fileEndStr = null;

        MatchPattern(String fileBeginStr, String fileExtn) {
            this.m_fileNameBeginStr = fileBeginStr;
            this.m_fileEndStr = fileExtn;
        }

        @Override
        public boolean accept(File dir, String fileName) {
            boolean result = false;
            if (VerificationUtil.isStringGood(this.m_fileNameBeginStr) && VerificationUtil.isStringGood(fileName)) {
                result = (fileName = fileName.trim()).startsWith(this.m_fileNameBeginStr) && (!VerificationUtil.isStringGood(this.m_fileEndStr) || fileName.endsWith(this.m_fileEndStr));
            }
            return result;
        }
    }
}

